program ParProg;

// *****************************************************************************
// *****************************************************************************
//
// !!! W A R N U N G !!! W A R N U N G !!! W A R N U N G !!!
// !!! W A R N I N G !!! W A R N I N G !!! W A R N I N G !!!
// =========================================================
//
// DIESE PROGARMM LSCHT DEN FLASH UND DAS EEPROM DES TARGET MEGA8
// THIS PROGRAM ERASES THE FLASH AND THE EEPROM OF THE TARGET MEGA8
//
// B E N U T Z U N G   A U F   E I G E N E S   R I S I K O
// U S E   A T   Y O U R   O W N   R I S K
//
// *****************************************************************************
// *****************************************************************************
//
// Aufgabe des Programms:
// Wiederherstellung der Werkseinstellungen fr die Fuses eines Mega8
// mit aktiviertem RSTDISBL, und/oder gesetzten LOCK BITS.
// Fhrt ein "Chip Erase" aus, um die Lock Bits zurckzusetzen
// und setzt die Fuses (hi/lo) auf $D9/$E1
//
// the object of the program:
// restore the factory default fuse settings on a Mega8
// with activated RSTDISBL, and/or enabled LOCK BITS.
// Perform a "Chip Erase" to reset the Lock Bits
// and set the fuses (hi/lo) to $D9/$E1
//
//
// Bedienungsanleitung:
// Instructions:
//
// setzen Sie den fehlerhaften Mega8 in den Target Sockel ein
// schalten Sie zunchst nur die 5V (DC) ein
// sobald die LED leuchtet (etwa 1 sek) schlieen Sie die 12V (DC) an
// drcken Sie kurz die Taste (oder halten Sie sie gedrckt)
// es dauert einige msek bis die LED blinkt
// entfernen Sie ZUNCHST die 12V
// dann entfernen Sie die 5V Versorgung
// der Target Mega8 ist jetzt gelscht und die Default Fuses sind aktiviert
// (1MHz, interner Takt)
//               ODER
// der Chip ist zerstrt
//               ODER
// Ihre Hardware ist fehlerhaft
//
// Viel Glck
// Gunter
//
// insert the faulty Mega8 in the target socket
// apply ONLY the 5V (DC)
// as far as the LED is on (about 1 sec) apply the 12V (DC)
// press the key (or hold it down)
// it takes some msec and the LED is blinking
// remove FIRST the 12V
// then remove the 5V
// the target Mega8 is now erased and the default fuse settings
// (1MHz, internal clock) are restored
//               OR
// the chip is permanentely damaged
//               OR
// your hardware is faulty
//
// good luck
// gunter


// and here we go:



{ $BOOTRST $00C00}         {Reset Jump to $00C00}
{$NOSHADOW}
{ $W+ Warnings}            {Warnings off}

Device = mega8, VCC=5;

Import SysTick, SwitchPort1;

From System Import ;

Define
        ProcClock   = 1000000;        {Hertz}
        SysTick     = 10;             {msec}
        StackSize   = $0064, iData;
        FrameSize   = $0064, iData;
        SwitchPort1 = PinC, $00;
        PolarityP1  = $00;            // polarity
                                      {port C1: switch to GND}

Implementation

{$IDATA}

{--------------------------------------------------------------}
{ Type Declarations }
type


{--------------------------------------------------------------}
{ Const Declarations }
const

{--------------------------------------------------------------}
{ Var Declarations }
{$IDATA}
var
  LED[@PortC,0] : Bit;                      {active low}

  U1[@PortB,7]  : Bit;
  U2[@PortB,6]  : Bit;
  XA1[@PortB,5] : Bit;
  XA0[@PortB,4] : Bit;
  BS1[@PortB,3] : Bit;
  WR[@PortB,2]  : Bit;
  BS2[@PortB,1] : Bit;
  XT[@PortB,0]  : Bit;

{--------------------------------------------------------------}
{ functions }

procedure InitPorts;
begin
  PortB := %00000100;
  DDRB  := %11111111;
  DDRD  := %11111111;
  PortC := %00000011;
  DDRC  := %00000001;
end InitPorts;

procedure XTP;
begin
  mDelay(20);
  Incl (XT);
  mDelay(1);
  Excl (XT);
  mDelay(50);
end XTP;

procedure WRP;
begin
  mDelay(20);
  Excl (WR);
  mDelay(1);
  Incl (WR);
  mDelay(50);
end WRP;

procedure LdCommand(cmd:byte);
begin
  Incl (XA1);
  Excl (XA0);
  Excl (BS1);
  mDelay(20);
  PortD := cmd;
  XTP;
end LDCommand;

procedure LdData(dat:byte);
begin
  Excl (XA1);
  Incl (XA0);
  mDelay(20);
  PortD := dat;
  XTP;
end LdData;


{--------------------------------------------------------------}
{ Main Program }
{$IDATA}

begin
  InitPorts;

  mDelay(250);
  EnableInts;
  mDelay(250);

// Init control pins, PAGEL is fix (connected to GND)
  Excl (XA1);
  Excl (XA0);
  Excl (BS1);
  Excl (BS2);
  Excl (XT);                                {to pulse XT high}
  Incl (WR);                                {to pulse WR low}
  mDelay(100);

  Excl (Led);                               {LED on}

// user should now apply 12V and press the key
  repeat until (Port_Stable1 AND $02) <> 0; {wait for key}

  Incl (Led);                               {LED off}

  Incl (U1);                                {target power on}
  Incl (U2);

  mDelay(20);

  LdCommand ($80);                          {Chip erase}
  WRP;

  LdCommand ($40);                          {write Fuse low}
  LdData ($E1);                             {Fuse := $E1}
  Excl (BS1);
  Excl (BS2);
  WRP;

  LdCommand ($40);                          {write Fuse high}
  LdData ($D9);                             {Fuse := $D9}
  INCL (BS1);
  Excl (BS2);
  WRP;

  Excl (BS1);
  Excl (U1);                                {target power off}
  Excl (U2);

  loop                                      {done: blink LED}
    Excl (LED);
    mdelay(300);
    Incl (LED);
    mdelay(300);
  endloop;
  
end ParProg.


